
#define ExitMenu_BGColor (RGB15(8,8,8)|BIT15)

#define ExitMenu_ItemsCount (5)
static const char *ExitMenu_pItems[ExitMenu_ItemsCount]={
  "Cancel.",
  "Overwrite save and exit.",
  "Save as name and exit.",
  "Create new ",
  "Exit without saving.",
};
static u32 ExitMenu_ItemIndex;

static UnicodeChar ExitMenu_NewFilename[128]={0,};

static void ExitMenu_DrawScreen_DrawTextA(CglCanvas *pcan,u32 x,u32 y,u16 col,const char *pstr)
{
  pcan->SetFontTextColor(RGB15(0,0,0)|BIT15);
  pcan->TextOutA(x+1,y+1,pstr);
  pcan->SetFontTextColor(col);
  pcan->TextOutA(x+0,y+0,pstr);
}

static void ExitMenu_DrawScreen_DrawTextW(CglCanvas *pcan,u32 x,u32 y,u16 col,const UnicodeChar *pstr)
{
  pcan->SetFontTextColor(RGB15(0,0,0)|BIT15);
  pcan->TextOutW(x+1,y+1,pstr);
  pcan->SetFontTextColor(col);
  pcan->TextOutW(x+0,y+0,pstr);
}

static void ExitMenu_DrawScreen(CglCanvas *pcan)
{
  pcan->FillFull(ExitMenu_BGColor);
  
  const u16 TextColor=RGB15(24,24,24)|BIT15;
  const u16 TextHighColor=RGB15(31,31,31)|BIT15;
  
  u32 tx=16;
  u32 ty=16;
  const u32 th=glCanvasTextHeight+2;
  
  ty+=th;
  
  ExitMenu_DrawScreen_DrawTextA(pcan,tx,ty,TextColor,"EXIT MENU");
  ty+=th*2;
  
  for(u32 idx=0;idx<ExitMenu_ItemsCount;idx++){
    const char *pstr=ExitMenu_pItems[idx];
    u16 col;
    if(idx==ExitMenu_ItemIndex){
      col=TextHighColor;
      ExitMenu_DrawScreen_DrawTextA(pcan,tx+0,ty,col,">");
      }else{
      col=TextColor;
    }
    ExitMenu_DrawScreen_DrawTextA(pcan,tx+8,ty,col,pstr);
    if(idx==3){
      const u32 tw=pcan->GetTextWidthA(pstr);
      UnicodeChar *pfnu=ExitMenu_NewFilename;
      ExitMenu_DrawScreen_DrawTextW(pcan,tx+8+tw,ty,col,pfnu);
    }
    ty+=th;
  }
  
}

static bool ExitMenu_KeyPress(u16 keys)
{
  if((keys&(KEY_UP|KEY_DOWN|KEY_LEFT|KEY_RIGHT))!=0){
    PlaySE_Short();
    if((keys&KEY_UP)!=0){
      if(0<ExitMenu_ItemIndex) ExitMenu_ItemIndex--;
    }
    if((keys&KEY_DOWN)!=0){
      if(ExitMenu_ItemIndex<(ExitMenu_ItemsCount-1)) ExitMenu_ItemIndex++;
    }
    if((keys&KEY_LEFT)!=0){
      ExitMenu_ItemIndex=0;
    }
    if((keys&KEY_RIGHT)!=0){
      ExitMenu_ItemIndex=ExitMenu_ItemsCount-1;
    }
    return(false);
  }
  
  if((keys&(KEY_START|KEY_SELECT|KEY_A))!=0){
    return(true);
  }
  
  return(false);
}

static void ExitMenu_SaveToFile(EFilenameType FilenameType,const UnicodeChar *pNewFilename)
{
  Sound_Start(WAVFN_Opening);
  
  CglCanvas *pcan=pScreenSub->pCanvas;
  pcan->SetColor(RGB15(0,0,0)|BIT15);
  pcan->FillBox(0,0,ScreenWidth,16*4);
  pcan->SetFontTextColor(RGB15(31,31,31)|BIT15);
  pcan->TextOutA(2,(16*1)+2,"Save text file and reboot...");
  pcan->TextOutA(2,(16*2)+2,"Please don't turn off power.");
  
  TextEdit_SaveToFile(FilenameType,pNewFilename);
}

static void ExitMenu_CreateNewFilename(void)
{
  UnicodeChar *pfnu=ExitMenu_NewFilename;
  pfnu[0]=0;
  
  {
    const CTextEditLine *pCurLine=TextEdit_GetTopLine();
    u32 idx=0;
    const UnicodeChar *pstr=pCurLine->GetPlaneStringBuffer();
    while(1){
      UnicodeChar wc=*pstr++;
      if(wc==0) break;
      if((wc<=UnicodeChar(' '))||(wc==0x3000)){
        if(idx==0){
          wc=0;
          }else{
          wc=UnicodeChar(' ');
          if(pfnu[idx-1]==wc) wc=0;
        }
      }
      if(wc==UnicodeChar('/')) wc=0;
      if(wc==UnicodeChar('\\')) wc=0;
      if(wc==UnicodeChar('!')) wc=0;
      if(wc==UnicodeChar('?')) wc=0;
      if(wc==UnicodeChar(':')) wc=0;
      if(wc==UnicodeChar(';')) wc=0;
      if(wc==UnicodeChar('*')) wc=0;
      if(wc==UnicodeChar('<')) wc=0;
      if(wc==UnicodeChar('>')) wc=0;
      if(wc==UnicodeChar('\"')) wc=0;
      if(wc==UnicodeChar('|')) wc=0;
      if(wc!=0){
        pfnu[idx++]=wc;
        if(idx==64) break;
      }
    }
    if(idx==0){
      DateTime_ResetNow();
      TDateTime dt=DateTime_GetNow();
      char dtstr[128];
      snprintf(dtstr,128,"%04d%02d%02d-%02d%02d%02d_NoTitle.txt",dt.Date.Year,dt.Date.Month,dt.Date.Day,dt.Time.Hour,dt.Time.Min,dt.Time.Sec);
      StrConvert_Ank2Unicode(dtstr,pfnu);
      }else{
      if(pfnu[idx-1]==UnicodeChar(' ')) idx--;
      const char *pext=".txt";
      StrConvert_Ank2Unicode(pext,&pfnu[idx]);
    }
  }
  
  _consolePrintf("New filename: ");
  while(1){
    UnicodeChar wc=*pfnu++;
    if(wc==0) break;
    if(wc<0x80){
      _consolePrintf("$%x[%c] ",wc,wc);
      }else{
      _consolePrintf("$%x ",wc);
    }
  }
  _consolePrintf("\n");
}

static bool ExitMenu_Execute(void)
{
  pScreenMain->pBackCanvas->FillFull(ExitMenu_BGColor);
  pScreenMain->Flip(true);
  
  CglCanvas *povrcan=new CglCanvas(&MM_Temp,NULL,ScreenWidth,ScreenHeight,pf15bit);
  pScreenMainOverlay->pCanvas->BitBltFullBeta(povrcan);
  pScreenMainOverlay->pCanvas->FillFull(0);
  
  ExitMenu_CreateNewFilename();
  
  ExitMenu_ItemIndex=0;
  
  ExitMenu_DrawScreen(pScreenSub->pCanvas);
  
  while(1){
    u16 keys=GetKeyInputWithXY();
    if(keys==0) break;
    swiWaitForVBlank();
  }
  
  bool res=false;
  
  while(1){
    u16 keys;
    while(1){
      keys=GetKeyInputWithXY();
      if(keys!=0) break;
      swiWaitForVBlank();
    }
    bool execute=false;
    bool cancel=false;
    if((keys&KEY_B)!=0){
      cancel=true;
      }else{
      if(ExitMenu_KeyPress(keys)==true) execute=true;
    }
    ExitMenu_DrawScreen(pScreenSub->pCanvas);
    while(1){
      keys=GetKeyInputWithXY();
      if(keys==0) break;
      swiWaitForVBlank();
    }
    if(cancel==true){
      PlaySE_Long();
      res=false;
      break;
    }
    if(execute==true){
      switch(ExitMenu_ItemIndex){
        case 0: PlaySE_Long(); res=false; break;
        case 1: ExitMenu_SaveToFile(EFT_Overwrite,NULL); res=true; break;
        case 2: ExitMenu_SaveToFile(EFT_SaveAs,NULL); res=true; break;
        case 3: ExitMenu_SaveToFile(EFT_NewFilename,ExitMenu_NewFilename); res=true; break;
        case 4: PlaySE_Long(); res=true; break;
      }
      break;
    }
  }
  
  povrcan->BitBltFullBeta(pScreenMainOverlay->pCanvas);
  if(povrcan!=NULL){
    delete povrcan; povrcan=NULL;
  }
  
  return(res);
}
